#include <iostream>

using namespace std;

class IDeviceA {
  public:
    virtual void displayDevice() = 0 ;
    virtual ~IDeviceA() {};
};
//--------------------------------------------------------------
class IDeviceB {
  public:
    virtual void displayDevice() = 0 ;
    virtual ~IDeviceB() {};
};
//--------------------------------------------------------------
class TRSDeviceA : public IDeviceA {
  private:
    void displayDevice() {
        cout << "RS 232C Device A" << endl ;
   }
};
//--------------------------------------------------------------
class TRSDeviceB : public IDeviceB {
  private:
    void displayDevice() {
        cout << "RS 232C Device B" << endl;
   }
};
//--------------------------------------------------------------
class TUSBDeviceB : public IDeviceB {
  private:
    void displayDevice() {
       cout << "USB Device B" << endl ;
   }
};
//--------------------------------------------------------------
class TUSBDeviceA : public IDeviceA {
  private:
    void displayDevice() {
        cout << "USB Device A" << endl ;
   }
};
//--------------------------------------------------------------
class IDeviceFactory {
  public:
    virtual IDeviceA* fDeviceA() = 0;
    virtual IDeviceB* fDeviceB() = 0;
    virtual ~IDeviceFactory() {};
};
//--------------------------------------------------------------
class TRS232CDeviceFactory : public IDeviceFactory {
  private:
    IDeviceA* fDeviceA() {
        return new TRSDeviceA ;
    }
    IDeviceB*  fDeviceB() {
        return new TRSDeviceB ;
    }
};
//--------------------------------------------------------------
class TUSBDeviceFactory : public IDeviceFactory {
  private:
    IDeviceA* fDeviceA() {
         return new TUSBDeviceA ;
    }
    IDeviceB* fDeviceB() {
         return new TUSBDeviceB ;
    }
};
//--------------------------------------------------------------
  IDeviceFactory *df;
  IDeviceB *id ;
//--------------------------------------------------------------
int main()
{
  df = new TUSBDeviceFactory;
  //df = new TRS232CDeviceFactory;

  id = df->fDeviceB();
  id->displayDevice();
  delete df;
  system("PAUSE");
  return 0;
}
//--------------------------------------------------------------

